/*
 * Decompiled with CFR 0.152.
 */
package blueduck.jellyfishing.item;

import blueduck.jellyfishing.entity.AbstractJellyfishEntity;
import blueduck.jellyfishing.registry.ModItems;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class NetJellyfishItem
extends Item {
    Supplier<EntityType<?>> entityType;

    public NetJellyfishItem(Item.Properties pProperties, Supplier<EntityType<?>> eType) {
        super(pProperties);
        this.entityType = eType;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.m_43722_();
        BlockPos blockpos = pContext.m_8083_();
        Direction direction = pContext.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        Entity entity = this.getType(itemstack.m_41783_()).m_20592_((ServerLevel)level, itemstack, pContext.m_43723_(), blockpos1, MobSpawnType.BUCKET, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (entity != null && !pContext.m_43723_().m_150110_().f_35937_) {
            ItemStack netItem = new ItemStack((ItemLike)ModItems.JELLYFISH_NET.get());
            if (itemstack.m_41793_()) {
                Map enchantmentmap = itemstack.getAllEnchantments();
                Object[] enchantments = enchantmentmap.keySet().toArray();
                Object[] levels = enchantmentmap.values().toArray();
                for (int i = 0; i < enchantmentmap.size(); ++i) {
                    netItem.m_41663_((Enchantment)enchantments[i], ((Integer)levels[i]).intValue());
                }
            }
            netItem.m_41721_(itemstack.m_41773_());
            pContext.m_43723_().m_21120_(pContext.m_43724_()).m_41774_(1);
            pContext.m_43723_().m_21008_(pContext.m_43724_(), netItem);
            if ((double)pContext.m_43723_().m_21120_(pContext.m_43724_()).getEnchantmentLevel(Enchantments.f_44986_) * 0.25 < pContext.m_43725_().m_213780_().m_188500_()) {
                pContext.m_43723_().m_21120_(pContext.m_43724_()).m_41622_(1, (LivingEntity)pContext.m_43723_(), p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
            }
            level.m_142346_((Entity)pContext.m_43723_(), GameEvent.f_157810_, blockpos);
            entity.getPersistentData().m_128379_("PersistenceRequired", true);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult blockhitresult = NetJellyfishItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        if (!(pLevel.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos, blockhitresult.m_82434_(), itemstack)) {
            EntityType<?> entitytype = this.getType(itemstack.m_41783_());
            AbstractJellyfishEntity entity = (AbstractJellyfishEntity)entitytype.m_20592_((ServerLevel)pLevel, itemstack, pPlayer, blockpos, MobSpawnType.BUCKET, false, false);
            if (entity == null) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                ItemStack netItem = new ItemStack((ItemLike)ModItems.JELLYFISH_NET.get());
                if (itemstack.m_41793_()) {
                    Map enchantmentmap = itemstack.getAllEnchantments();
                    Object[] enchantments = enchantmentmap.keySet().toArray();
                    Object[] levels = enchantmentmap.values().toArray();
                    for (int i = 0; i < enchantmentmap.size(); ++i) {
                        netItem.m_41663_((Enchantment)enchantments[i], ((Integer)levels[i]).intValue());
                    }
                }
                netItem.m_41721_(itemstack.m_41773_());
                pPlayer.m_21008_(pHand, netItem);
                if ((double)pPlayer.m_21120_(pHand).getEnchantmentLevel(Enchantments.f_44986_) * 0.25 < pLevel.m_213780_().m_188500_()) {
                    pPlayer.m_21120_(pHand).m_41622_(1, (LivingEntity)pPlayer, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
                }
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            pLevel.m_220400_((Entity)pPlayer, GameEvent.f_157810_, entity.m_20182_());
            entity.getPersistentData().m_128379_("PersistenceRequired", true);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public EntityType<?> getType(@Nullable CompoundTag pNbt) {
        return this.entityType.get();
    }

    public int m_6473_() {
        return 1;
    }
}

